#include <stdio.h>
#include <stdlib.h>

extern int COMPFRAMES;

extern color green, black, white, magenta, gray, yellow;

#define M_W 1
#define M_A 2
#define M_S 4
#define M_D 8
#define M_SPACE 16
#define M_MOUSE1 32
#define M_MOUSE2 64
/*
#define DATA1 128
#define DATA2 256
#define DATA3 512
#define DATA4 1024
#define DATA5 2048
#define DATA6 4096
#define DATA7 8192
#define DATA8 16384
#define DATA9 32768
#define DATA10 65536
*/


struct actorframe {
	long keys;
	int mx, my;
};

struct movieframe {
	actorframe *actorframes;
	long data;
};

struct movie {
	int numactors;
	int numframes;
	int lastframe;
	int datasize;
	
	void *data;
	movieframe *frames;
};

movie *movie_createmovie() {
	movie *m;
	m = new(movie);
	m->numactors = 0;
	m->numframes = 0;
	m->datasize = 0;
	m->data = NULL;
	m->frames = NULL;
	m->lastframe = -1;
	return m;
}

void movie_recordactorframe(movie *m, int actorno, int frame, long keys, int mx, int my) {
	int i;
	if(frame > m->lastframe) {
		m->lastframe = frame;
	}
	if(frame + 1 > m->numframes) {
		m->numframes += 50;
		m->frames = (movieframe *)realloc(m->frames, sizeof(movieframe) * m->numframes);
		for(i = m->numframes - 50; i < m->numframes; i++) {
			m->frames[i].actorframes = (struct actorframe *)malloc(sizeof(actorframe) * (m->numactors));
			m->frames[i].data = 0;
		}
	}
	if(actorno + 1 > m->numactors) {
		m->numactors++;
		for(i = 0; i < m->numframes; i++) {
			m->frames[i].actorframes = (struct actorframe *)realloc(m->frames[i].actorframes, sizeof(actorframe) * m->numactors);
		}
	}
	m->frames[frame].actorframes[actorno].keys = keys;
	m->frames[frame].actorframes[actorno].mx = mx;
	m->frames[frame].actorframes[actorno].my = my;
}

void movie_getkeys(movie *m, int actorno, int frame, long &keys, int &mx, int &my) {
	keys = m->frames[frame].actorframes[actorno].keys;
	mx = m->frames[frame].actorframes[actorno].mx;
	my = m->frames[frame].actorframes[actorno].my;
}

/*
struct actorframe {
	long keys;
	int mx, my;
};

struct frame {
	actorframe *actorframes;
	long data;
};

struct movie {
	int numactors;
	int numframes;
	int lastframe;
	int datasize;
	
	void *data;
	frame *frames;
};
*/

void movie_savemovie(movie *m, char *fn) {
	FILE *output;
	int i;
	
	output = fopen(fn, "w+b");

	fwrite(m, sizeof(movie), 1, output);
	fwrite(m->frames, sizeof(movieframe), m->numframes, output);
	for(i = 0; i < m->numframes; i++) {
		fwrite(m->frames[i].actorframes, sizeof(actorframe), m->numactors, output);
	}

	fclose(output);
}

void movie_loadmovie(movie *m, char *fn) {
	FILE *input;
	int i;
	int oldnumframes;
	movieframe *oldframes;

	oldnumframes = m->numframes;
	oldframes = m->frames;
	
	input = fopen(fn, "rb");


	fread(m, sizeof(movie), 1, input);

	m->frames = oldframes;

	m->frames = (movieframe *)realloc(m->frames, sizeof(movieframe) * m->numframes);

	fread(m->frames, sizeof(movieframe), m->numframes, input);

	for(i = oldnumframes; i < m->numframes; i++) {
		m->frames[i].actorframes = (struct actorframe *)malloc(sizeof(actorframe) * (m->numactors));
		m->frames[i].data = 0;
	}

	for(i = 0; i < m->numframes; i++) {
		fread(m->frames[i].actorframes, sizeof(actorframe), m->numactors, input);
	}

	fclose(input);
}